/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import org.netbeans.microedition.lcdui.AbstractInfoScreen;
import org.netbeans.microedition.util.CancellableTask;

public class WaitScreen
extends AbstractInfoScreen {
    private CancellableTask task = null;
    private Thread backgroundExecutor = null;
    private Displayable failureDisplayble;
    private Alert failureAlert;

    public WaitScreen(Display display) throws IllegalArgumentException {
        super(display);
    }

    public void setFailureDisplayable(Displayable failureDisplayble) {
        this.failureDisplayble = failureDisplayble;
    }

    public void setFailureDisplayable(Alert failureAlert, Displayable failureDisplayble) throws IllegalArgumentException {
        if (failureAlert != null && failureDisplayble == null) {
            throw new IllegalArgumentException("A failureDisplayable parameter cannot be null if the failureAlert parameter is not null.");
        }
        if (failureDisplayble instanceof Alert) {
            throw new IllegalArgumentException("failureDisplayable paremter cannot be Alert.");
        }
        this.failureAlert = failureAlert;
        this.failureDisplayble = failureDisplayble;
    }

    public void setTask(CancellableTask task) {
        this.task = task;
    }

    public CancellableTask getTask() {
        return this.task;
    }

    protected void showNotify() {
        super.showNotify();
        if (this.task != null) {
            if (this.backgroundExecutor == null) {
                this.backgroundExecutor = new Thread(new BackgroundExecutor(this.task));
                this.backgroundExecutor.start();
            }
        } else {
            this.getDisplay().callSerially(new Runnable(){

                public void run() {
                    WaitScreen.this.switchToNextDisplayable();
                }
            });
        }
    }

    private class BackgroundExecutor
    implements Runnable {
        private CancellableTask task;

        public BackgroundExecutor(CancellableTask task) throws IllegalArgumentException {
            if (task == null) {
                throw new IllegalArgumentException("Task parameter cannot be null");
            }
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.run();
            }
            finally {
                if (this.task.hasFailed() && WaitScreen.this.failureDisplayble != null) {
                    AbstractInfoScreen.switchToDisplayable(WaitScreen.this.getDisplay(), WaitScreen.this.failureAlert, WaitScreen.this.failureDisplayble);
                } else {
                    WaitScreen.this.switchToNextDisplayable();
                }
                WaitScreen.this.backgroundExecutor = null;
            }
        }
    }
}

